<?php
/**
 * BusinessUnitApi
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Settings\BusinessUnits
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Business Units
 *
 * Retrieve Business Unit information.
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Settings\BusinessUnits\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use HubSpot\Client\Settings\BusinessUnits\ApiException;
use HubSpot\Client\Settings\BusinessUnits\Configuration;
use HubSpot\Client\Settings\BusinessUnits\HeaderSelector;
use HubSpot\Client\Settings\BusinessUnits\ObjectSerializer;

/**
 * BusinessUnitApi Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Settings\BusinessUnits
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class BusinessUnitApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'getByUserID' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getByUserID
     *
     * Get Business Units for a user
     *
     * @param  string $user_id Identifier of user to retrieve. (required)
     * @param  string[] $properties The names of properties to optionally include in the response body. The only valid value is &#x60;logoMetadata&#x60;. (optional)
     * @param  string[] $name The names of Business Units to retrieve. If empty or not provided, then all associated Business Units will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getByUserID'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Settings\BusinessUnits\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Settings\BusinessUnits\Model\CollectionResponsePublicBusinessUnitNoPaging|\HubSpot\Client\Settings\BusinessUnits\Model\Error
     */
    public function getByUserID($user_id, $properties = null, $name = null, string $contentType = self::contentTypes['getByUserID'][0])
    {
        list($response) = $this->getByUserIDWithHttpInfo($user_id, $properties, $name, $contentType);
        return $response;
    }

    /**
     * Operation getByUserIDWithHttpInfo
     *
     * Get Business Units for a user
     *
     * @param  string $user_id Identifier of user to retrieve. (required)
     * @param  string[] $properties The names of properties to optionally include in the response body. The only valid value is &#x60;logoMetadata&#x60;. (optional)
     * @param  string[] $name The names of Business Units to retrieve. If empty or not provided, then all associated Business Units will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getByUserID'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Settings\BusinessUnits\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Settings\BusinessUnits\Model\CollectionResponsePublicBusinessUnitNoPaging|\HubSpot\Client\Settings\BusinessUnits\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getByUserIDWithHttpInfo($user_id, $properties = null, $name = null, string $contentType = self::contentTypes['getByUserID'][0])
    {
        $request = $this->getByUserIDRequest($user_id, $properties, $name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Settings\BusinessUnits\Model\CollectionResponsePublicBusinessUnitNoPaging' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Settings\BusinessUnits\Model\CollectionResponsePublicBusinessUnitNoPaging' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Settings\BusinessUnits\Model\CollectionResponsePublicBusinessUnitNoPaging', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Settings\BusinessUnits\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Settings\BusinessUnits\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Settings\BusinessUnits\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Settings\BusinessUnits\Model\CollectionResponsePublicBusinessUnitNoPaging';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Settings\BusinessUnits\Model\CollectionResponsePublicBusinessUnitNoPaging',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Settings\BusinessUnits\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getByUserIDAsync
     *
     * Get Business Units for a user
     *
     * @param  string $user_id Identifier of user to retrieve. (required)
     * @param  string[] $properties The names of properties to optionally include in the response body. The only valid value is &#x60;logoMetadata&#x60;. (optional)
     * @param  string[] $name The names of Business Units to retrieve. If empty or not provided, then all associated Business Units will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getByUserID'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getByUserIDAsync($user_id, $properties = null, $name = null, string $contentType = self::contentTypes['getByUserID'][0])
    {
        return $this->getByUserIDAsyncWithHttpInfo($user_id, $properties, $name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getByUserIDAsyncWithHttpInfo
     *
     * Get Business Units for a user
     *
     * @param  string $user_id Identifier of user to retrieve. (required)
     * @param  string[] $properties The names of properties to optionally include in the response body. The only valid value is &#x60;logoMetadata&#x60;. (optional)
     * @param  string[] $name The names of Business Units to retrieve. If empty or not provided, then all associated Business Units will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getByUserID'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getByUserIDAsyncWithHttpInfo($user_id, $properties = null, $name = null, string $contentType = self::contentTypes['getByUserID'][0])
    {
        $returnType = '\HubSpot\Client\Settings\BusinessUnits\Model\CollectionResponsePublicBusinessUnitNoPaging';
        $request = $this->getByUserIDRequest($user_id, $properties, $name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getByUserID'
     *
     * @param  string $user_id Identifier of user to retrieve. (required)
     * @param  string[] $properties The names of properties to optionally include in the response body. The only valid value is &#x60;logoMetadata&#x60;. (optional)
     * @param  string[] $name The names of Business Units to retrieve. If empty or not provided, then all associated Business Units will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getByUserID'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getByUserIDRequest($user_id, $properties = null, $name = null, string $contentType = self::contentTypes['getByUserID'][0])
    {

        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling getByUserID'
            );
        }




        $resourcePath = '/business-units/v3/business-units/user/{userId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $properties,
            'properties', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $name,
            'name', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'userId' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
